 ; Ŀ
 ;   Gyc - move an ss to the middle of a box.                              
 ;   Also contains Gy, which does the same thing without the rotation.     
 ;   Copyright 2001, 2005, 2010 by Rocket Software Ltd.                    
 ;   Gy=C.                                                                 
 ; 

 ; Ŀ
 ;   Mover - move an ss from one point to another while rotating it 360    
 ;   degrees.  Takes three arguments, a base point, a new point, and the   
 ;   ss name.  Returns nothing of use.                                     
 ; 
 (DEFUN MOVER (pa gnupt ss / dist angg)
  (setq jumps 30)
  (setq dist (/ (distance pa gnupt) jumps))
  (setq angg (angle pa gnupt))
  (repeat jumps
          (command ".move" ss "" "0,0" (polar (list 0 0) angg dist))
          (command ".rotate" ss "" pa (/ 360.0 jumps))
          (setq pa (polar pa angg dist))))
 ; Ŀ
 ;   Mover end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Gyc: find the centre point of a box and of an ss.          
 ;   Takes no arguments, returns a list: a selection set, a start point    
 ;   (the ss centrepoint), and a destination pint (the box centre).        
 ;   Loads and calls Puss.                                                 
 ;   Kills osnap settings - the calling function should restore these.     
 ; 
 (DEFUN GYC (/ ss ll ur mxlst gnupt sscen)
  (if (not pussy) (load "puss"))
 ; Ŀ
 ;   Get an ss.                                                            
 ; 
  (write-line "Select things to centre: ")
  (setvar "osmode" 0)
  (setq ss (ssget))
 ; Ŀ
 ;   Get two corners of the box to put the stuff in, find the middle.      
 ; 
  (setvar "osmode" 2052)
  (setq ll (getpoint "Corner o'Box: "))
  (if (null (setq ur (getcorner ll "\nOther: ")))
      (setq ur ll))
  (setvar "osmode" 0)
  (setq gnupt (polar ll (angle ll ur) (/ (distance ll ur) 2.0)))
 ; Ŀ
 ;   Find the geometric centre of the ss.                                  
 ; 
  (setq mxlst (pussy ss))
  (setq sscen (list (/ (+ (car mxlst) (cadr mxlst)) 2)
                    (/ (+ (caddr mxlst) (cadddr mxlst)) 2)))
 ; Ŀ
 ;   Return an ss and two points.                                          
 ; 
 (list ss sscen gnupt))
 ; Ŀ
 ;   Subroutine Gyc end.                                                   
 ; 

 ; Ŀ
 ;   Gy - move an ss to the middle of a box.                               
 ;   Like Gyc but without the rotation.                                    
 ; 
 (DEFUN C:GY (/ *error* ss osmo)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
  (setq osmo (getvar "osmode"))
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (command ".undo" "end")
  (princ))
 ; Ŀ
 ;   Call Gyc to get the required data.                                    
 ; 
  (setq ss (gyc))
 ; Ŀ
 ;   Centre the ss in the box.                                             
 ; 
  (command ".move" (car ss) "" (cadr ss) (caddr ss))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setvar "osmode" osmo)
  (command ".redraw")
  (command ".undo" "end")
 (princ))

 ; Ŀ
 ;   Gyc.                                                                  
 ; 
 (DEFUN C:GYC (/ *error* ss osmo)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
  (setq osmo (getvar "osmode"))
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (command ".undo" "end")
  (princ))
 ; Ŀ
 ;   Call Gyc to get the required data.                                    
 ; 
  (setq ss (gyc))
 ; Ŀ
 ;   Centre the ss in the box.                                             
 ; 
  (mover (cadr ss) (caddr ss) (car ss))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setvar "osmode" osmo)
  (command ".undo" "end")
 (princ))